function SfuncTest(block)
% Level-2 M file S-function for applying Sobel filtering  
% (image edge detection demonstration).
%   Copyright 1990-2004 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $    
  
  setup(block);

%endfunction

function setup(block)
  
  %% Register dialog parameter: edge direction 
  block.NumDialogPrms = 2;
  block.DialogPrmsTunable = {'Tunable','Tunable'};
 
  %% Register ports
  block.NumInputPorts  = 1;
  block.NumOutputPorts = 3;
  
  %% Setup port properties
  block.SetPreCompInpPortInfoToDynamic;
  %block.SetPreCompOutPortInfoToDynamic;

  block.InputPort(1).DatatypeID   = 0;
  block.InputPort(1).Complexity   = 'Real';
  block.InputPort(1).SamplingMode = 'Sample';
  blocl.InputPort(1).Overwritable = false; % No in-place operation
  
  block.OutputPort(1).DatatypeID   = 0;
  block.OutputPort(1).Complexity   = 'Real';
  block.OutputPort(1).SamplingMode = 'Sample';
  block.OutputPort(1).Dimensions   = 1;
  
  block.OutputPort(2).DatatypeID   = 0;
  block.OutputPort(2).Complexity   = 'Real';
  block.OutputPort(2).SamplingMode = 'Sample';
  block.OutputPort(2).Dimensions   = 1;
  
  block.OutputPort(3).DatatypeID   = 0;
  block.OutputPort(3).Complexity   = 'Real';
  block.OutputPort(3).SamplingMode = 'Sample';
  block.OutputPort(3).Dimensions   = 1;
  
  %% Register block methods (through MATLAB function handles)
  block.RegBlockMethod('Outputs', @Output);
  block.RegBlockMethod('WriteRTW',@WriteRTW);

  %% Block runs on TLC in accelerator mode.
  block.SetAccelRunOnTLC(true);





function Output(block)
  %pat = size(block.InputPort(1).Data)
  %%dir = block.DialogPrm(1).Data;
 %ratara = size(BancFiltres(block.InputPort(1).Data))
% block.DialogPrm(1).Data
%  block.OutputPort(2).Data
 


%block.OutputPort(1).Data = BancFiltres(block.InputPort(1).Data);
block.OutputPort(1).Data = Moy(block.InputPort(1).Data);


    block.OutputPort(2).Data = block.DialogPrm(1).Data
  block.OutputPort(3).Data = block.DialogPrm(2).Data
%endfunction
block.DialogPrm(1).Data
block.DialogPrm(2).Data
% function WriteRTW(block)
%   
%    block.WriteRTWParam('matrix', 'M',    [1 2; 3 4]);
%    block.WriteRTWParam('string', 'Mode', 'Auto');
   

function moy = Moy(mat)
moy = mean(mat);
moy = mean(moy)
function y = BancFiltres(s1)


[ro,co]=size(s1);


filtAn = [0.0013 -0.0002 -0.0106 0.0027 0.0347 -0.0192 -0.0367 0.2577 0.5496 0.3404 -0.0433 -0.1013 0.0054 0.0224 -0.0004 -0.0024];

phi0 = filtAn;


j = 0;    
h0 = reverse(phi0);                   %  cette ondelette nous donne le signal : eeg32
h1 = reverse(mirror(phi0));           % ... : residu
j = 1;   
H0 = upSample(h0);                  
H1 = upSample(h1);                 
phi10 = waveletLo(phi0,H0);    % eeg16
phi11 = waveletHi(phi0,H1);    % beta = [16-32]Hz
j = 2;
H0 = upSample(H0);
H1 = upSample(H1);
phi20 = waveletLo(phi10,H0);   % eeg8L
phi21 = waveletHi(phi10,H1);   % eeg8H
phi22 = waveletHi(phi11,H1);   % [16-24]Hz
phi23 = waveletLo(phi11,H0);   % [24-32]Hz
j = 3;
H0 = upSample(H0);
H1 = upSample(H1);
phi30 = waveletLo(phi20,H0);   % eeg4
phi31 = waveletHi(phi20,H1);   % theta
phi32 = waveletHi(phi21,H1);   % alpha   = [8-12]Hz
phi33 = waveletLo(phi21,H0);   % sigma   = [12-16]Hz
phi34 = waveletLo(phi22,H0);   % [16-20]Hz
phi35 = waveletHi(phi22,H1);   % [20-24]Hz
phi36 = waveletHi(phi23,H1);   % [24-28]Hz
phi37 = waveletLo(phi23,H0);   % [28-32]Hz




 for q=1:co
     mu(:,q) = conv(s1(:,q),reverse(phi23)');   X(:,q) = redconv(mu(:,q),phi23);%%35,47,52,51,32good,46,44b,45
 end

 a = X(:,1);
 b = X(:,1);
 
 a = (a-mean(a)).^2;
 b = (b-mean(b)).^2;
 
% figure(1)
% plot(a,'r')
% hold on
% plot(b)

%----------------------------  Dtection tat de l'oeil -Nickel-  ---------
for q=1:co
     alpha(:,q) = conv(s1(:,q),reverse(phi22)');   X2(:,q) = redconv(alpha(:,q),phi22);%%35,47,52,51,32good,46,44b,45
end

y=[X2(:,1)-mean(X2(:,1)).^2,X2(:,2)-mean(X2(:,2)).^2];
size(y)
%figure(2)
%plot(ya)
%--------------------------------------------------------------------------


function fout = upSample(fin)
o = zeros(1,1);
n = length(fin);
fout = 0;
ftemp = [fin(1);o];
fout = ftemp;
for i=2:n-1
   ftemp = [fin(i);o];
   fout = [fout;ftemp];
end;
fout = [fout;fin(n)];
fout = fout';
   

function y = waveletHi(x,qmf)
y = conv(reverse((mirror(qmf))),x);


function y = waveletLo(x,qmf)
y = conv(qmf,x);


function y = mirror(x)
y = -( (-1).^(1:length(x)) ).*x;


function r = reverse(x)
r = x(length(x):-1:1);

function y = redconv(s,f)
i = round(length(f)/2);
y = s((i):(length(s)-(length(f)-i)));  

    

